package editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewRogueBlockPaletteObjectWizard extends JPanel {
	
	private JTextField imageField;
	private SharedColor transparentColor;
	private MicroColorCanvas colorCanvas;
	private JCheckBox blockIsPassThrough;
	
	private JTextField defaultSpeedField;
	
	private JTextField widthField;
	private JTextField heightField;
	
	private JRadioButton stationaryButton;
	private JRadioButton verticalButton;
	private JRadioButton horizontalButton;
	
	public static final int STATIONARY_BLOCK = 0;
	public static final int VERTICAL_BLOCK = 1;
	public static final int HORIZONTAL_BLOCK = 2;
	
	
	
	private String imageFileName;
	private boolean shouldBePassThrough;
	private int kindOfRogueBlock;
	private int defaultSpeed;
	private int blockWidth;
	private int blockHeight;
	
	private boolean wasCancelled = true;
	
	private Window encasingFrame;
	
	private ScreenPaletteObject paletteObject;
	
	
	public NewRogueBlockPaletteObjectWizard(Window theFrame) {
		
		paletteObject = null;
		encasingFrame = theFrame;
		
		this.setLayout(new BorderLayout());
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new GridLayout(1, 5));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				cancelWasClicked();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				okWasClicked();
			}
		});
		bottomPanel.add(okButton);
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
		
		JPanel mainArea = new JPanel();
		mainArea.setLayout(new GridLayout(2, 1));
		
		JPanel topArea = new JPanel();
		topArea.setLayout(new GridLayout(2, 1));
		
		JPanel imageSelectArea = new JPanel();
		imageSelectArea.setLayout(new FlowLayout());
		imageSelectArea.add(new JLabel("Image file:  "));
		imageField = new JTextField();
		imageField = new JTextField(20);
		imageField.setHorizontalAlignment(JTextField.CENTER);
		imageField.setEditable(false);
		imageSelectArea.add(imageField);
		JButton imageBrowse = new JButton("Browse...");
		imageBrowse.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				selectImageButton();
			}
		});
		imageSelectArea.add(imageBrowse);
		topArea.add(imageSelectArea);
		
		
		JPanel colorAndSpeedArea = new JPanel();
		colorAndSpeedArea.setLayout(new GridLayout(1,2));
		
		JPanel transparentColorArea = new JPanel();
		transparentColorArea.setLayout(new FlowLayout());
		transparentColorArea.add(new JLabel("Transparent color: "));
		transparentColor = new SharedColor();
		colorCanvas = new MicroColorCanvas(transparentColor);
		transparentColorArea.add(colorCanvas);
		JButton changeColorButton = new JButton("Change...");
		changeColorButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, colorCanvas);
			}
		});
		transparentColorArea.add(changeColorButton);
		colorAndSpeedArea.add(transparentColorArea);
		
		JPanel speedArea = new JPanel();
		speedArea.setLayout(new FlowLayout());
		speedArea.add(new JLabel("default speed: "));
		defaultSpeedField = new JTextField(5);
		speedArea.add(defaultSpeedField);
		colorAndSpeedArea.add(speedArea);
		
		topArea.add(colorAndSpeedArea);
		
		mainArea.add(topArea);
		
		
		JPanel centerArea = new JPanel();
		centerArea.setLayout(new GridLayout());
		
		JPanel widthAndHeightArea = new JPanel();
		widthAndHeightArea.setLayout(new GridLayout(3, 1));
		
		JPanel passthruArea = new JPanel();
		passthruArea.setLayout(new FlowLayout());
		blockIsPassThrough = new JCheckBox("<html>block should<br>be pass-through?</html>");
		passthruArea.add(blockIsPassThrough);
		widthAndHeightArea.add(passthruArea);
		
		JPanel widthArea = new JPanel();
		widthArea.setLayout(new FlowLayout());
		widthArea.add(new JLabel("Width:"));
		widthField = new JTextField(5);
		widthArea.add(widthField);
		widthAndHeightArea.add(widthArea);
		
		JPanel heightArea = new JPanel();
		heightArea.setLayout(new FlowLayout());
		heightArea.add(new JLabel("Height:"));
		heightField = new JTextField(5);
		heightArea.add(heightField);
		widthAndHeightArea.add(heightArea);
		
		centerArea.add(widthAndHeightArea);
		
		
		JPanel typeArea = new JPanel();
		typeArea.setLayout(new GridLayout(3,1));
		stationaryButton = new JRadioButton("stationary");
		typeArea.add(stationaryButton);
		verticalButton = new JRadioButton("vertical");
		typeArea.add(verticalButton);
		horizontalButton = new JRadioButton("horizontal");
		typeArea.add(horizontalButton);
		ButtonGroup group = new ButtonGroup();
		group.add(stationaryButton);
		group.add(verticalButton);
		group.add(horizontalButton);
		centerArea.add(typeArea);
		
		mainArea.add(centerArea);
		
		this.add(mainArea, BorderLayout.CENTER);
		
		
	}
	
	
	public void cancelWasClicked() {
		wasCancelled = true;
		encasingFrame.setVisible(false);
		encasingFrame.dispose();
	}
	
	public void okWasClicked() {
		
		StringBuffer messages = new StringBuffer();
		
		if(imageField.getText() == null || imageField.getText().length() == 0) {
			messages.append("You need to pick an image.\n");
		} else {
			imageFileName = imageField.getText();
		}
		
		if(transparentColor.getColor() == null) {
			messages.append("You need to pick a background color.\n");
		}
		
		if(widthField.getText() == null) {
			messages.append("You need to enter a width.\n");
		} else {
			try {
				blockWidth = Integer.parseInt(widthField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("The width you entered was not a number.\n");
			}
		}
		
		if(heightField.getText() == null) {
			messages.append("You need to enter a height.\n");
		} else {
			try {
				blockHeight = Integer.parseInt(heightField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("The height you entered was not a number.\n");
			}
		}
		
		if(defaultSpeedField.getText() == null) {
			messages.append("You need to enter a default speed.\n");
		} else {
			try {
				defaultSpeed = Integer.parseInt(defaultSpeedField.getText().trim());
			} catch (NumberFormatException e) {
				messages.append("The default speed you entered was not a number.\n");
			}
		}
		
		
		if(stationaryButton.isSelected()) {
			kindOfRogueBlock = STATIONARY_BLOCK;
		} else if(verticalButton.isSelected()) {
			kindOfRogueBlock = VERTICAL_BLOCK;
		} else if(horizontalButton.isSelected()) {
			kindOfRogueBlock = HORIZONTAL_BLOCK;
		} else {
			messages.append("You need to select whether the given block will be stationary, vertically-moving, or horizontally-moving.\n");
		}
		
		shouldBePassThrough = blockIsPassThrough.isSelected();
		
		if(messages.length() > 0) {
			JOptionPane.showMessageDialog(this, messages.toString(), "Unable to build block", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		
		
		encasingFrame.setVisible(false);
		encasingFrame.dispose();
		

		wasCancelled = false;
		
	}
	
	
	
	public void selectImageButton() {
		
//		System.out.println("now in selectImageButton");
		
		FileDialog fd = null;
		
		if(encasingFrame instanceof JDialog) {
			fd = new FileDialog((JDialog) encasingFrame, "Select Image File", FileDialog.LOAD);
		} else {
			fd = new FileDialog((JFrame) encasingFrame, "Select Image File", FileDialog.LOAD);
		}
		fd.setModal(true);
		fd.setVisible(true);
		
		if(fd.getDirectory() != null && fd.getFile() != null) {
			imageField.setEditable(true);
			imageField.setText(fd.getDirectory() + fd.getFile());
			imageField.setEditable(false);
			imageField.repaint();
//			System.out.println("just set the text to <<" + fd.getDirectory() + fd.getFile() + ">>");
		}
		
		
	}
	
	
	public static void main(String [] args) {
		JFrame frame = new JFrame();
		frame.setContentPane(new NewRogueBlockPaletteObjectWizard(frame));
		
		frame.setPreferredSize(new Dimension(500, 300));
		frame.setMinimumSize(new Dimension(500, 300));
		frame.setMaximumSize(new Dimension(500, 300));
		
		frame.setVisible(true);
		
	}
	
	public static NewRogueBlockPaletteObjectWizard openWizard(ScreenPaletteObject po) {
		
		JDialog frame = new JDialog();
		
		NewRogueBlockPaletteObjectWizard returnValue = new NewRogueBlockPaletteObjectWizard(frame, po);
		
		frame.setContentPane(returnValue);
		
		frame.setPreferredSize(new Dimension(500, 300));
		frame.setMinimumSize(new Dimension(500, 300));
		frame.setMaximumSize(new Dimension(500, 300));
		
		frame.setModal(true);
		frame.setVisible(true);
		
		return returnValue;
		
		
	}
	
	
	public static NewRogueBlockPaletteObjectWizard openWizard() {
		
		JDialog frame = new JDialog();
		
		NewRogueBlockPaletteObjectWizard returnValue = new NewRogueBlockPaletteObjectWizard(frame);
		
		frame.setContentPane(returnValue);
		
		frame.setPreferredSize(new Dimension(500, 300));
		frame.setMinimumSize(new Dimension(500, 300));
		frame.setMaximumSize(new Dimension(500, 300));
		
		frame.setModal(true);
		frame.setVisible(true);
		
		return returnValue;
		
		
	}
	
	
	public boolean wasCancelled() {
		return wasCancelled;
	}
	
	public String getImageFileName() {
		return imageFileName;
	}


	public SharedColor getTransparentColor() {
		return transparentColor;
	}


	public int getDefaultSpeed() {
		return defaultSpeed;
	}


	public int getBlockWidth() {
		return blockWidth;
	}


	public int getBlockHeight() {
		return blockHeight;
	}
	
	public boolean shouldBePassThrough() {
		return shouldBePassThrough;
	}
	
	public int getKindOfRogueBlock() {
		return kindOfRogueBlock;
	}
	
	
	public NewRogueBlockPaletteObjectWizard(Window theFrame, ScreenPaletteObject spo) {
		
		encasingFrame = theFrame;
		paletteObject = spo;
		
		
		String strFileName;
		Color colTransColor;
		String strDefaultSpeed;
		boolean boolPassThru;
		String strWidth;
		String strHeight;
		int intMode;
		
		
		if(paletteObject instanceof RogueBlockScreenPaletteObject) {
			RogueBlockScreenPaletteObject narrowed = (RogueBlockScreenPaletteObject) paletteObject;
			strFileName = narrowed.getFileName();
			colTransColor = narrowed.getImage().getTransparentColor();
			strDefaultSpeed = "0";
			boolPassThru = narrowed.shouldBePassThru();
			strWidth = Integer.toString(narrowed.getImage().getDesiredWidth());
			strHeight = Integer.toString(narrowed.getImage().getDesiredHeight());
			intMode = STATIONARY_BLOCK;
		} else if(paletteObject instanceof VerticalBlockScreenPaletteObject) {
			VerticalBlockScreenPaletteObject narrowed = (VerticalBlockScreenPaletteObject) paletteObject;
			strFileName = narrowed.getFileName();
			colTransColor = narrowed.getImage().getTransparentColor();
			strDefaultSpeed = Integer.toString(narrowed.getDefaultSpeed());
			boolPassThru = narrowed.shouldBePassThru();
			strWidth = Integer.toString(narrowed.getImage().getDesiredWidth());
			strHeight = Integer.toString(narrowed.getImage().getDesiredHeight());
			intMode = VERTICAL_BLOCK;
		} else if(paletteObject instanceof HorizontalBlockScreenPaletteObject) {
			HorizontalBlockScreenPaletteObject narrowed = (HorizontalBlockScreenPaletteObject) paletteObject;
			strFileName = narrowed.getFileName();
			colTransColor = narrowed.getImage().getTransparentColor();
			strDefaultSpeed = Integer.toString(narrowed.getDefaultSpeed());
			boolPassThru = narrowed.shouldBePassThru();
			strWidth = Integer.toString(narrowed.getImage().getDesiredWidth());
			strHeight = Integer.toString(narrowed.getImage().getDesiredHeight());
			intMode = HORIZONTAL_BLOCK;
		} else {
			encasingFrame.setVisible(false);
			encasingFrame.dispose();
			JOptionPane.showMessageDialog(null, "Unable to edit this palette object; selected object was not a rogue/vertical/horizontal block.","Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		 
		
		this.setLayout(new BorderLayout());
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new GridLayout(1, 5));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				cancelWasClicked();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				okWasClicked();
			}
		});
		bottomPanel.add(okButton);
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
		
		JPanel mainArea = new JPanel();
		mainArea.setLayout(new GridLayout(2, 1));
		
		JPanel topArea = new JPanel();
		topArea.setLayout(new GridLayout(2, 1));
		
		JPanel imageSelectArea = new JPanel();
		imageSelectArea.setLayout(new FlowLayout());
		imageSelectArea.add(new JLabel("Image file:  "));
		imageField = new JTextField();
		imageField = new JTextField(20);
		imageField.setHorizontalAlignment(JTextField.CENTER);
		imageField.setEditable(false);
		imageField.setText(strFileName);
		imageSelectArea.add(imageField);
		JButton imageBrowse = new JButton("Browse...");
		imageBrowse.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				selectImageButton();
			}
		});
		imageSelectArea.add(imageBrowse);
		topArea.add(imageSelectArea);
		
		
		JPanel colorAndSpeedArea = new JPanel();
		colorAndSpeedArea.setLayout(new GridLayout(1,2));
		
		JPanel transparentColorArea = new JPanel();
		transparentColorArea.setLayout(new FlowLayout());
		transparentColorArea.add(new JLabel("Transparent color: "));
		transparentColor = new SharedColor();
		transparentColor.setColor(colTransColor);
		colorCanvas = new MicroColorCanvas(transparentColor);
		transparentColorArea.add(colorCanvas);
		JButton changeColorButton = new JButton("Change...");
		changeColorButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				BackgroundColorPopUpPanel.popUpColorSelectDialog(transparentColor, colorCanvas);
			}
		});
		transparentColorArea.add(changeColorButton);
		colorAndSpeedArea.add(transparentColorArea);
		
		JPanel speedArea = new JPanel();
		speedArea.setLayout(new FlowLayout());
		speedArea.add(new JLabel("default speed: "));
		defaultSpeedField = new JTextField(5);
		defaultSpeedField.setText(strDefaultSpeed);
		speedArea.add(defaultSpeedField);
		colorAndSpeedArea.add(speedArea);
		
		topArea.add(colorAndSpeedArea);
		
		mainArea.add(topArea);
		
		
		JPanel centerArea = new JPanel();
		centerArea.setLayout(new GridLayout());
		
		JPanel widthAndHeightArea = new JPanel();
		widthAndHeightArea.setLayout(new GridLayout(3, 1));
		
		JPanel passthruArea = new JPanel();
		passthruArea.setLayout(new FlowLayout());
		blockIsPassThrough = new JCheckBox("<html>block should<br>be pass-through?</html>");
		if(boolPassThru)
			blockIsPassThrough.setSelected(true);
		passthruArea.add(blockIsPassThrough);
		widthAndHeightArea.add(passthruArea);
		
		JPanel widthArea = new JPanel();
		widthArea.setLayout(new FlowLayout());
		widthArea.add(new JLabel("Width:"));
		widthField = new JTextField(5);
		widthField.setText(strWidth);
		widthArea.add(widthField);
		widthAndHeightArea.add(widthArea);
		
		JPanel heightArea = new JPanel();
		heightArea.setLayout(new FlowLayout());
		heightArea.add(new JLabel("Height:"));
		heightField = new JTextField(5);
		heightField.setText(strHeight);
		heightArea.add(heightField);
		widthAndHeightArea.add(heightArea);
		
		centerArea.add(widthAndHeightArea);
		
		
		JPanel typeArea = new JPanel();
		typeArea.setLayout(new GridLayout(3,1));
		stationaryButton = new JRadioButton("stationary");
		typeArea.add(stationaryButton);
		verticalButton = new JRadioButton("vertical");
		typeArea.add(verticalButton);
		horizontalButton = new JRadioButton("horizontal");
		typeArea.add(horizontalButton);
		ButtonGroup group = new ButtonGroup();
		group.add(stationaryButton);
		group.add(verticalButton);
		group.add(horizontalButton);
		centerArea.add(typeArea);
		
		switch(intMode) {
		case STATIONARY_BLOCK:
			stationaryButton.setSelected(true);
			break;
		case VERTICAL_BLOCK:
			verticalButton.setSelected(true);
			break;
		case HORIZONTAL_BLOCK:
			horizontalButton.setSelected(true);
			break;
		}
		
		stationaryButton.setEnabled(false);
		verticalButton.setEnabled(false);
		horizontalButton.setEnabled(false);
		
		
		mainArea.add(centerArea);
		
		this.add(mainArea, BorderLayout.CENTER);
		
		
	}
	
	
}
